/**
* \file: AutoCompletion.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_UTILS_AUTOCOMPLETION_H
#define CARPLAY_UTILS_AUTOCOMPLETION_H

#include "PoolTemplate.h"

namespace adit { namespace carplay
{

class CARPLAY_HIDDEN AutoCompletion
{
public:
    typedef void* AutoCompletionContext;

    AutoCompletion(void (*completion)(void* context), void* context);
    ~AutoCompletion();

    AutoCompletionContext GetAdditionalReference();
    static void Completion(AutoCompletionContext context);

private:
    struct _Reference
    {
        _Reference() { count = 0; completion = nullptr; context = nullptr; }
        inline void Take() { count = 1; }
        inline bool IsFree() const { return count == 0; }

        uint32_t count;
        void (*completion)(void* context);
        void* context;
    };

    static PoolTemplate<_Reference, 64> pool;
    _Reference* reference;
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_UTILS_AUTOCOMPLETION_H */
